/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Collections;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.ReinforcedPistonMovingBlockEntity;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPistonBaseBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ReinforcedMovingPistonBlock
extends MovingPistonBlock {
    public ReinforcedMovingPistonBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.getDestroyProgress(x$0, x$1, x$2, x$3), state, player, level, pos);
    }

    public static BlockEntity newMovingBlockEntity(BlockPos pos, BlockState state, BlockState movedState, CompoundTag tag, Direction direction, boolean extending, boolean shouldHeadBeRendered) {
        return new ReinforcedPistonMovingBlockEntity(pos, state, movedState, tag, direction, extending, shouldHeadBeRendered);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ReinforcedMovingPistonBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.REINFORCED_PISTON_BLOCK_ENTITY.get()), ReinforcedPistonMovingBlockEntity::tick);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof ReinforcedPistonMovingBlockEntity) {
            ReinforcedPistonMovingBlockEntity pistonBlockEntity = (ReinforcedPistonMovingBlockEntity)blockEntity;
            pistonBlockEntity.finalTick();
        }
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockPos oppositePos = pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite());
        BlockState oppositeState = level.getBlockState(oppositePos);
        if (oppositeState.getBlock() instanceof ReinforcedPistonBaseBlock && ((Boolean)oppositeState.getValue((Property)PistonBaseBlock.EXTENDED)).booleanValue()) {
            level.removeBlock(oppositePos, false);
        }
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity = builder.getLevel().getBlockEntity(BlockPos.containing((Position)((Position)builder.getParameter(LootContextParams.ORIGIN))));
        if (blockEntity instanceof ReinforcedPistonMovingBlockEntity) {
            ReinforcedPistonMovingBlockEntity be = (ReinforcedPistonMovingBlockEntity)blockEntity;
            return be.getMovedState().getDrops(builder);
        }
        return Collections.emptyList();
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReinforcedPistonMovingBlockEntity) {
            ReinforcedPistonMovingBlockEntity be = (ReinforcedPistonMovingBlockEntity)blockEntity;
            return be.getCollisionShape(level, pos);
        }
        return Shapes.empty();
    }
}

